unit Wpspdlg1;
{ SpellDialog ---------------------------------
  TextProcessor for Delphi
  CopyRight 1996 by Julian Ziersch Software, Mnchen

  This unit demonstrates how to use the spelling interface
  functions of WPRichText.
  --------------------------------------------- }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, WPWinCtr;

type
  TWPSpDialog = class(TForm)        
    WordList: TListBox;
    Word: TEdit;
    ReplaceAs: TEdit;
    Ignore: TBitBtn;
    Replace: TBitBtn;
    Cancel: TBitBtn;
    procedure IgnoreClick(Sender: TObject);
    procedure ReplaceClick(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
    fsFirstCall : Boolean;
    fsEditBox   : TWPCustomRtfEdit;
    procedure SetEditBox(x : TWPCustomRtfEdit);
  public
    { Public-Deklarationen }
    property EditBox : TWPCustomRtfEdit read fsEditBox write SetEditBox;
  end;

TWPSpellCheckDlg = class(TComponent)
private
  dia       : TWPSpDialog;
  fsEditBox : TWPCustomRtfEdit;
public
  destructor  Destroy; override;
  procedure Execute;
published
  property EditBox : TWPCustomRtfEdit read fsEditBox write fsEditBox;
end;

var
  WPSpDialog: TWPSpDialog;

implementation

{$R *.DFM}

destructor TWPSpellCheckDlg.Destroy;
begin
  if dia<>nil then
  begin
        if dia.visible then dia.Close;
        dia.Free;
  end;
  inherited Destroy;
end;

procedure TWPSpellCheckDlg.Execute;  { Will not free the Dialogbox because it is nnon modal ! }
begin
 if assigned(fsEditBox) then
 begin
   if dia=nil then dia := TWPSpDialog.Create(Self);
   dia.EditBox := fsEditBox;
   fsEditBox.Spell_FromCursorPos;
   dia.Show;
 end;
end;

procedure TWPSpDialog.SetEditBox(x : TWPCustomRtfEdit);
begin
  fsEditBox := x;
  if x<>nil then x.Spell_FromCursorPos;
end;


procedure TWPSpDialog.IgnoreClick(Sender: TObject);
var
 s : String;
begin
 while TRUE do
 begin
  EditBox.Spell_FromCursorPos;
  s := EditBox.Spell_GetNextWord;
  if s='' then break;
  { test Dictionary .... ################################
    if not InDictionary(s) then
    begin
       EditBox.Spell_SelectWord;
       WordList.Strings.Assign( GuessList );
       break;
    end
    else continue;
    ##################################################### }
   { without a dictonary any word is unknown: }
      EditBox.Spell_SelectWord;
      break;
 end;
 Word.Text      := s;
 ReplaceAs.Text := s;
 if (s='') and (fsFirstCall=FALSE) then close;
end;

{ Replace will replace the selected Text.
  If you use the procedure
  EditBox.Spell_ReplaceWord(s : string) the replacment will be done
  invisibly.
  If you have a non modal spell dialog, the use of Spell_ReplaceWord might
  cause errors if the user has changed the text meanwhile.
}

procedure TWPSpDialog.ReplaceClick(Sender: TObject);
begin
  if CompareStr(EditBox.SelText,Word.Text)=0 then  { Replace selceted Text }
     EditBox.SelText := ReplaceAs.Text;
  IgnoreClick(Sender);
end;

procedure TWPSpDialog.CancelClick(Sender: TObject);
begin
  EditBox.Spell_FromCursorPos;
  Close;
end;

procedure TWPSpDialog.FormShow(Sender: TObject);
begin
  fsFirstCall := TRUE;
  IgnoreClick(Sender);
  fsFirstCall := FALSE;
end;

end.
